import { LinkProps } from 'next/link'
import { PropsWithChildren } from 'react'
import { Link } from '../next-view-transitions'
import { cn } from '@/lib/utils'
import { focusRing } from '@/lib/styles'

export function NavigationLink({ children, className, ...props }: PropsWithChildren<LinkProps> & { className?: string }) {
  return (
    <Link
      className={cn(focusRing, className)}
      {...props}
    >
      {children}
    </Link>
  )
}
